/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

//#include <stdlib.h>
#include "drmcontextsizes.h"

#include "tclib.h"
#include "tOEMIMP.h"
#include "tstutils.h"

/* global data buffer */
#define GDATA_COUNT 2
#define GDATA_TOTAL_COUNT (GDATA_COUNT + 1)
#define GDATA_DEVCERT GDATA_COUNT
DRM_STRING g_dstrData[GDATA_TOTAL_COUNT];


//**********************************************************//

/* Remove devcert, devcert template and private key file */
DRM_RESULT Test_RemoveDeviceData(long argc, char **argv)
{
	DRM_RESULT dr;
	ChkDR(RemoveDRMFile(RMFILE_ALL));
ErrorExit:
	return dr;
}

/* Copy devcert template and private key file and create the devcert optionally */
DRM_RESULT Test_SetDeviceEnv(long argc, char **argv)
{
	DRM_RESULT dr;
	DRM_CONST_STRING dstrDT = {0}, dstrPrvk = {0};
/*    unsigned int len1 = 0, len2 = 0;*/

	ChkArg(argc == 3 && argv[2]);
    if (argv[0] != NULL)
    {
		MakeDRMString(&dstrDT, argv[0]);
    }
    if (argv[1] != NULL)
    {
		MakeDRMString(&dstrPrvk, argv[1]);
    }

       	
	ChkDR(SetDeviceEnv(dstrDT.pwszString, dstrPrvk.pwszString, !DX_VOS_StrCmp(argv[2], "TRUE")));
ErrorExit:
	DX_VOS_MemFree((DRM_WCHAR*)dstrDT.pwszString);
	DX_VOS_MemFree((DRM_WCHAR*)dstrPrvk.pwszString);
	return dr;
}

/* Test the api DRM_DDC_GetDeviceCertificate 
	argv[0]: size of the output buffer or NULL, EMPTY
	argv[1]: dwFlag: 0 or 1 (DRM_DCP_CREATE_DEVCERT_IF_NOT_EXISTING)
	argv[2]: crypto context: NORMAL or NULL
	argv[3]: output buffer index: 0 or 1
*/
DRM_RESULT Test_API_GetDeviceCertificate(long argc, char **argv)
{
	DRM_RESULT dr;
	DRM_STRING *pdstrData = NULL;
	DRM_DWORD dwFlags;
	DRM_CRYPTO_CONTEXT *pCrypto = NULL;
	DRM_LONG i;
	
	ChkArg(argc == 4 && argv[1]);

	if (argv[0]) {
		ChkArg(argv[3]);
		i = OEM_atol(argv[3]);
		ChkArg(i >= 0 && i < GDATA_COUNT);

		DX_VOS_MemFree(g_dstrData[i].pwszString);

		if (*argv[0]) {
			g_dstrData[i].cchString = OEM_atol(argv[0]) / sizeof(DRM_WCHAR);

			ChkMem(g_dstrData[i].pwszString = (DRM_WCHAR*)DX_VOS_MemMalloc(g_dstrData[i].cchString * sizeof(DRM_WCHAR)));
		} else {
			g_dstrData[i].pwszString = NULL;
			g_dstrData[i].cchString = 0;
		}

		pdstrData = &g_dstrData[i];
	}

	dwFlags = OEM_atol(argv[1]);

	if (argv[2])
		ChkMem(pCrypto = (DRM_CRYPTO_CONTEXT*)DX_VOS_MemMalloc(sizeof(DRM_CRYPTO_CONTEXT)));

	ChkDR(DRM_DDC_GetDeviceCertificate(pdstrData, dwFlags, pCrypto));
ErrorExit:
	DX_VOS_MemFree(pCrypto);
	return dr;
}

static DRM_STRING* _GetDataBuffer(const char *szArg)
{
	DRM_RESULT dr;
	DRM_STRING *pOut = NULL;
	if (szArg) {
		if (!DX_VOS_StrCmp(szArg, "Devcert")) { /* Read the real devcert */
			DX_VOS_MemFree(g_dstrData[GDATA_DEVCERT].pwszString);
			g_dstrData[GDATA_DEVCERT].pwszString = NULL;
			OEM_GetDeviceCert(NULL, &g_dstrData[GDATA_DEVCERT].cchString);
			ChkMem(g_dstrData[GDATA_DEVCERT].pwszString = (DRM_WCHAR*)DX_VOS_MemMalloc(g_dstrData[GDATA_DEVCERT].cchString));
			ChkDR(OEM_GetDeviceCert((DRM_BYTE*)g_dstrData[GDATA_DEVCERT].pwszString, &g_dstrData[GDATA_DEVCERT].cchString));
			g_dstrData[GDATA_DEVCERT].cchString /= sizeof(DRM_WCHAR);
			pOut = &g_dstrData[GDATA_DEVCERT];
		} else {
			long i = OEM_atol(szArg);
			ChkArg(i >= 0 && i < GDATA_COUNT);
			pOut = &g_dstrData[i];
		}
	}
ErrorExit:
	return pOut;
}

DRM_RESULT Test_CompareDataBuffer(long argc, char **argv)
{
	DRM_RESULT dr = DRM_SUCCESS;
	DRM_STRING *pdstr1, *pdstr2;
	
	ChkArg(argc == 2);
	ChkArg(pdstr1 = _GetDataBuffer(argv[0]));
	ChkArg(pdstr2 = _GetDataBuffer(argv[1]));
	if (pdstr1->cchString != pdstr2->cchString ||
		DX_VOS_MemCmp(pdstr1->pwszString, pdstr2->pwszString, pdstr2->cchString * sizeof(DRM_WCHAR)))
		dr = DRM_S_FALSE;
ErrorExit:
	return dr;
}

/*	Verify the devcert in the data buffer
	argv[0]: data buffer index
*/
DRM_RESULT Test_VerifyDevcert(long argc, char **argv)
{
	DRM_RESULT dr = DRM_SUCCESS;
	DRM_STRING *pdstrDevcert = NULL;
	DRM_CONST_STRING dstrDevcert;
	DRM_CRYPTO_CONTEXT *pCrypto = NULL;

	ChkArg(argc == 1);
	ChkArg(pdstrDevcert = _GetDataBuffer(argv[0]));

	/* Verify it*/
	dstrDevcert.pwszString = (const DRM_WCHAR*)pdstrDevcert->pwszString;
	dstrDevcert.cchString = pdstrDevcert->cchString;

	ChkMem(pCrypto = (DRM_CRYPTO_CONTEXT*)DX_VOS_MemMalloc(sizeof(DRM_CRYPTO_CONTEXT)));
	ChkDR(DRM_DCP_VerifyDeviceCert(&dstrDevcert, DRM_DCP_VERIFY_ENTIRE_DEVCERT, pCrypto));
ErrorExit:
	DX_VOS_MemFree(pCrypto);
	return dr;
}

DRM_RESULT DDC_PreTestCase(long lTCID, char *strTCName)
{
	int i;
	for (i = 0; i < GDATA_TOTAL_COUNT; i++)
		g_dstrData[i].pwszString = NULL;

	return Test_RemoveDeviceData(0, NULL);
}

DRM_RESULT DDC_PostTestCase(long lTCID, char *strTCName)
{
	int i;
	for (i = 0; i < GDATA_TOTAL_COUNT; i++)
		DX_VOS_MemFree(g_dstrData[i].pwszString);
	return DRM_SUCCESS;
}

/*
IMPLEMENT_DEFAULT_WARPTEST

BEGIN_APIMAP(DeviceDevcertTest_ansi, "ddctest")
	API_ENTRY(Test_RemoveDeviceData)
	API_ENTRY(Test_SetDeviceEnv)
	API_ENTRY(Test_CompareDataBuffer)
	API_ENTRY(Test_VerifyDevcert)
	API_ENTRY(Test_API_GetDeviceCertificate)
END_APIMAP
*/
